<?php
ini_set('display_errors', 1);
// Iniciar sesión si no está iniciada
if(session_status() === PHP_SESSION_NONE) session_start();
include(__DIR__ . '/functions.php');
// Verificación de acceso (solo permitir si está logueado)
$public_pages = ['index.php']; // agrega aquí otros archivos públicos
$current_page = basename($_SERVER['PHP_SELF']);
if (!in_array($current_page, $public_pages)) {
    if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
        header("Location: index.php");
        exit;
    }
}
$adTypeJsonPath = __DIR__ . '/ad_type.json';
$adTypeData = json_decode(file_get_contents($adTypeJsonPath), true);
$currentAdType = $adTypeData['adType'] ?? 'manual';
if ($currentAdType === 'tmdb') {
    $adsPageUrl = "tmdb_api.php";
} else {
    $adsPageUrl = "ads.php";
}
$log_check = $db->select('users', '*', 'id = :id', '', [':id' => 1]);
$loggedinuser = !empty($log_check) ? $log_check[0]['username'] : null;

if (empty($loggedinuser) && isset($_SESSION['name']) && $_SESSION['name'] === $loggedinuser) {
    header("Location: index.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
  <meta name="author" content="LYA TV PLUS" />
  <title>LYA TV PLUS MXPanels</title>

  <!-- CSS & Libs -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/3.2.3/animate.min.css" />
  <link rel="stylesheet" href="css/rgvip.css" />
  <!-- JS -->
  <script src="https://cdn.jsdelivr.net/npm/particles.js@2.0.0/particles.min.js"></script>
  <style>
    .modal-body .list-group-item, .modal-body .list-group-item i { color: #000 !important; }
    #sidebar-wrapper {
      transition: margin-left .3s ease;
      margin-left: 0;
    }
    #menuToggle {
    z-index: 1051; /* más alto que el sidebar */
    position: relative; /* necesario para que z-index funcione */
  }
    #wrapper.toggled #sidebar-wrapper { margin-left: -250px; }
    #page-content-wrapper, #page-content-wrapper .container-fluid {
      transition: margin-left .3s ease;
      margin-left: 250px;
    }
    #wrapper.toggled #page-content-wrapper,
    #wrapper.toggled #page-content-wrapper .container-fluid {
      margin-left: 0;
    }
    nav.navbar { flex-wrap: nowrap !important; }
    @media (max-width: 768px) {
      #sidebar-wrapper { margin-left: -250px; }
      #wrapper.toggled #sidebar-wrapper { margin-left: 0; }
      #page-content-wrapper, #page-content-wrapper .container-fluid { margin-left: 0; }
      #wrapper.toggled #page-content-wrapper,
      #wrapper.toggled #page-content-wrapper .container-fluid { margin-left: 250px; }
    }
  </style>
</head>
<body>
  <div id="particles-js"></div>
  <div class="d-flex" id="wrapper">
    <div class="sidebar-overlay" id="sidebarOverlay"></div>
    <!-- Sidebar -->
    <div id="sidebar-wrapper">
      <div class="sidebar-heading">LYA TV PLUS MX</div>
      <a class="list-group-item text-center" href="https://t.me/lya_tv_plus_mx" target="_blank">
        &#169; <?=date("Y")?> * IBO 4.3 LYA. TV*
      </a>
      <div class="list-group list-group-flush">
      <!-- Sistemas -->
  <small class="text-muted px-3 mt-3 d-block">Herramientas</small>
  <a class="list-group-item list-group-item-action" href="sistema_rgvip.php">
    <i class="fa fa-cogs"></i> Limpieza del sistema y Recordatorios
  </a>
  <!-- Personalización -->
  <small class="text-muted px-3 mt-3 d-block">Personalización</small>
  <a class="list-group-item list-group-item-action" href="#" data-toggle="modal" data-target="#modalPersonalizar">
    <i class="fa fa-paint-brush"></i> Personalizar
  </a>
  <!-- DNS -->
  <small class="text-muted px-3 mt-3 d-block">DNS</small>
  <a class="list-group-item list-group-item-action" href="dns.php">
    <i class="fa fa-globe"></i> Registrar DNS
  </a>
  <a class="list-group-item list-group-item-action" href="migrar_dns.php">
    <i class="fa fa-server"></i> Migración masiva DNS
  </a>
  <!-- Usuarios -->
  <small class="text-muted px-3 mt-3 d-block">Usuarios</small>
  <a class="list-group-item list-group-item-action" href="playlists.php">
    <i class="fa fa-users"></i> Usuarios por MAC
  </a>
  <!--<a class="list-group-item list-group-item-action" href="mRTXSubscription.php">
    <i class="fa fa-calendar"></i> Alertas de expiración
  </a>
  <a class="list-group-item list-group-item-action" href="mRTXTrial.php">
    <i class="fa fa-desktop"></i> Cuenta Demo
  </a>-->
  <!-- Códigos -->
  <small class="text-muted px-3 mt-3 d-block">Códigos</small>
  <a class="list-group-item list-group-item-action" href="generar_codigo.php">
    <i class="fa fa-key"></i> Generar Códigos
  </a>
  <a class="list-group-item list-group-item-action" href="activar.php">
    <i class="fa fa-check-circle"></i> Activar Códigos
  </a>
  <a class="list-group-item list-group-item-action" href="gestionar_codigos.php">
    <i class="fa fa-cogs"></i> Gestionar Códigos
  </a>
  <!-- Enlaces -->
  <small class="text-muted px-3 mt-3 d-block">Enlaces</small>
  <a class="list-group-item list-group-item-action" href="buscar_users.php">
    <i class="fa fa-share-alt"></i> Enlace para Revendedores
  </a>
  <a class="list-group-item list-group-item-action" href="activar_publico.php">
    <i class="fa fa-share-alt"></i> Enlace para Clientes
  </a>
  <!-- Perfil
  <small class="text-muted px-3 mt-3 d-block">Perfil</small>
  <a class="list-group-item list-group-item-action" href="user.php">
    <i class="fa fa-user"></i> Actualizar Credenciales
  </a>-->
</div>
    </div>
    <!-- Main content -->
<div id="page-content-wrapper">
  <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
    <button class="btn btn-primary" id="menuToggle">
      <img src="img/logorgvip.png?ts=<?= time(); ?>" width="25" height="25" alt="Logo">
    </button>
    <div class="mx-auto text-white" id="pageMessages"></div>
    
    <!-- Dropdown de Usuario -->
    <div class="dropdown ml-auto">
  <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenuButton"
          data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
    <i class="fas fa-user"></i>
  </button>
  <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenuButton">
    <a class="dropdown-item" href="user.php"><i class="fas fa-id-card mr-2"></i> Perfil</a>
    <div class="dropdown-divider"></div>
    <a class="dropdown-item text-danger" href="logout.php"><i class="fas fa-sign-out-alt mr-2"></i> Salir</a>
  </div>
</div>
  </nav>
  
  <div class="container-fluid mt-4">
    <!-- Aquí va tu contenido -->
  </div>
  <!-- Modal -->
<div class="modal fade" id="modalPersonalizar" tabindex="-1" role="dialog" aria-labelledby="modalPersonalizarLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modalPersonalizarLabel">Opciones de Personalización</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Cerrar"><span>&times;</span></button>
      </div>
      <div class="modal-body list-group">
        <a class="list-group-item list-group-item-action" href="themes.php"><i class="fa fa-image"></i> Cambiar Temas</a>
        <a class="list-group-item list-group-item-action" href="sports.php"><i class="fa fa-futbol-o"></i> Botón de Deportes</a>
        <a class="list-group-item list-group-item-action" href="ads.php"><i class="fa fa-home"></i> Anuncios Manual/Auto-Tmdb</a>
        <a class="list-group-item list-group-item-action" href="settings.php"><i class="fa fa-commenting"></i> Texto de Playlist</a>
        <a class="list-group-item list-group-item-action" href="qrcode.php"><i class="fa fa-commenting"></i> Enviar QR Code</a>
        <a class="list-group-item list-group-item-action" href="linkweb.php"><i class="fa fa-commenting"></i> Link para Botón Sitio Web</a>
        <a class="list-group-item list-group-item-action" href="txtqrdown.php"><i class="fa fa-commenting"></i> Texto debajo del botón de Sitio Web</a>
        <a class="list-group-item list-group-item-action" href="rgvip_intro.php"><i class="fa fa-film"></i> Video de Introducción</a>
      </div>
    </div>
  </div>
</div>
  <!-- Scripts (versión limpia y sin duplicados) -->
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/js/bootstrap.min.js"></script>
<script src="js/panelrgvip.js"></script>
<script>
$(document).ready(function() {
    // Inicialización estándar de Bootstrap
    $('.dropdown').dropdown();
    
    // Manejar clic en el botón del dropdown
    $('.dropdown-toggle').on('click', function(e) {
    e.stopPropagation();
    var $menu = $(this).next('.dropdown-menu');
    $('.dropdown-menu').not($menu).removeClass('show');
    $menu.toggleClass('show');
});
    
    // Permitir que los enlaces del dropdown funcionen normalmente
    $('.dropdown-menu a').on('click', function(e) {
        e.stopPropagation(); // Evitar que el clic cierre el menú inmediatamente
    });
    
    // Cerrar el menú al hacer clic fuera
    $(document).on('click', function() {
        $('.dropdown-menu').removeClass('show');
    });
});
</script>
  <!--<script>
  document.addEventListener("DOMContentLoaded", function () {
    const menuToggle = document.getElementById("menuToggle");
    const wrapper = document.getElementById("wrapper");
    if (menuToggle && wrapper) {
      menuToggle.addEventListener("click", function () {
        wrapper.classList.toggle("toggled");
      });
    }
  });
</script>-->
</body>
</html>
